/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.worldgen;

import com.blackgear.platform.common.worldgen.modifier.BiomeContext;
import com.blackgear.platform.common.worldgen.modifier.BiomeWriter;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.data.tags.RCBiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class WorldGeneration {
    public static void setupMobSpawns(BiomeWriter writer, BiomeContext context) {
        if (context.is(RCBiomeTags.CAN_BURNED_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.BURNED.get(), ((Integer)RottenCreatures.CONFIG.burnedWeight.get()).intValue(), 4, 4));
        }
        if (context.is(RCBiomeTags.CAN_FROSTBITTEN_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.FROSTBITTEN.get(), ((Integer)RottenCreatures.CONFIG.frostbittenWeight.get()).intValue(), 4, 4));
        }
        if (context.is(RCBiomeTags.CAN_GLACIAL_HUNTER_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.GLACIAL_HUNTER.get(), ((Integer)RottenCreatures.CONFIG.glacialHunterWeight.get()).intValue(), 1, 3));
        }
        if (context.is(RCBiomeTags.CAN_SWAMPY_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.SWAMPY.get(), ((Integer)RottenCreatures.CONFIG.swampyWeight.get()).intValue(), 4, 4));
        }
        if (context.hasEntity(() -> EntityType.ZOMBIE) && context.is(RCBiomeTags.CAN_UNDEAD_MINER_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.UNDEAD_MINER.get(), ((Integer)RottenCreatures.CONFIG.undeadMinerWeight.get()).intValue(), 1, 4));
        }
        if (context.is(RCBiomeTags.CAN_MUMMY_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.MUMMY.get(), ((Integer)RottenCreatures.CONFIG.mummyWeight.get()).intValue(), 1, 3));
        }
        if (context.is(RCBiomeTags.CAN_DEAD_BEARD_SPAWN_ON)) {
            writer.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(RCEntityTypes.DEAD_BEARD.get(), ((Integer)RottenCreatures.CONFIG.deadBeardWeight.get()).intValue(), 1, 1));
        }
    }
}

